<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fn="fn"
    xmlns:pl="http://product-live.com"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:map="http://www.w3.org/2005/xpath-functions/map"
    version="3.0"
    exclude-result-prefixes="xs fn pl map">
    
    <xsl:output method="xml" indent="yes" encoding="UTF-8" cdata-section-elements="" />

    <xsl:param name="jsonUrl" select="'./items.json'" />
    <!--
        The function json-doc() returns a map from a json file
        If your json is a raw string you can use parse-json() function
    -->
    <xsl:variable name="json" select="json-doc($jsonUrl)" />
    
    <xsl:template match="/">
        <!-- 
            Values can be accessed with ? for example $json?tableKey or with $json('tableKey')
            Use the first one when you know the property name, use the second one when you have to deal with dynamic properties
        -->
        <Table key="{$json?tableKey}">
            <Items>
                <!-- items is an array, ?* means all elements of the array -->
                <xsl:for-each select="$json?items?*">
                    <xsl:variable name="item" select="." />
                    <Item>
                        <Identifier key="ean">
                            <xsl:value-of select="$item?ean"/>
                        </Identifier>
                        <!--
                            map:keys list all keys of an object
                            you see that you can also pass predicates, here we want all properties except ean
                        -->
                        <xsl:for-each select="map:keys($item)[.!='ean']">
                            <!-- . means the current value, which is the property name -->
                            <Field key="{.}">
                                <!-- map:get allows to get value of a property from his name -->
                                <xsl:value-of select="map:get($item, .)"/>
                            </Field>
                        </xsl:for-each>
                    </Item>
                </xsl:for-each>
            </Items>
            <Second-Item-Ean>
                <!-- To access an element at a particular position in an array you must use (position) it starts at 1 -->
                <xsl:value-of select="$json?items?(2)?ean"/>
            </Second-Item-Ean>
            <Count-Phones>
                <!-- You can use any xsl functions, and you can use predicates -->
                <xsl:value-of select="count($json?items?*[?typology='phone'])"/>
            </Count-Phones>
            <!-- Nee more functions on map? See https://www.saxonica.com/html/documentation/functions/map/ -->
        </Table>
    </xsl:template>
</xsl:stylesheet>